classdef class_REVS_battery
	%UNTITLED Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		
		chemistry;									% Battery Chemistry from enum_battery_type
		initial_soc_norm;							% Initial pack state of charge [0-1]
		
		capacity_Coulombs;							% Battery charge capacity [Culombs]
		use_second_order_model;						% Use second order transient response model [bool]
		
		max_voltage_V;								%
		min_voltage_V;								%
				
		powerlimit_discharge_map_W;					% Discharging Power Limit [Watts]
		powerlimit_charge_map_W;					% Charging Power Limit [Watts]
		powerlimit_map_index_soc_norm;				% Power Limit SOC Axis
		powerlimit_map_index_temp_degC;				% Power Limit Temperature Axis [degC]
		discharge_derate_soc_norm;					% Derating for minimum SOC limit [0-1]
		charge_derate_soc_norm;						% Derating for maximum SOC limit [0-1]
		
		open_circuit_voltage_map_discharge_V;		% Open Circuit Voltage Map while Discharging [V]
		open_circuit_voltage_map_charge_V;			% Open Circuit Voltage Map while Charging [V]
		open_circuit_voltage_map_average_V;			% Open Circuit Voltage Average of Charging & Discharging [V]
		open_circuit_voltage_map_index_temp_degC;	% Open Circuit Voltage Map Temperature Axis [degC]
		open_circuit_voltage_map_index_soc_norm;	% Open Circuit Voltage Map SOC Axis [0-1]
		use_average_open_circuit_Volts;				% Use Average Open Circut Voltage Map instead of charging & discharging maps
		
		transient_RC_index_soc_norm;				% Transient response RC constants SOC Axis [0-1]
		transient_RC_index_temp_degC;				% Transient response RC constants temperature Axis [degC]
		transient_R_discharge_short_term_Ohms;		% Transient response short term RC resistance when discharging [Ohms]
		transient_R_charge_short_term_Ohms;			% Transient response short term RC resistance when charging [Ohms]
		transient_R_discharge_long_term_Ohms;		% Transient response long term RC resistance when discharging [Ohms]
		transient_R_charge_long_term_Ohms;			% Transient response long term RC resistance when charging [Ohms]
		transient_C_discharge_short_term_Farads;	% Transient response short term RC capacitance when discharging [Farads]
		transient_C_charge_short_term_Farads;		% Transient response short term RC capacitance when charging [Farads]
		transient_C_discharge_long_term_Farads;		% Transient response long term RC capacitance when discharging [Farads]
		transient_C_charge_long_term_Farads;		% Transient response long term RC capacitance when charging [Farads]
		resistance_map_discharge_Ohms;				% Internal Resistance map while discharging [Ohms]
		resistance_map_charge_Ohms;					% Internal Resistance map while charging [Ohms]
		resistance_map_index_temp_degC;				% Internal Resistance map temperature axis [degC]
		resistance_map_index_soc_norm;				% Internal Resistance map SOC axis [0-1]
		
		charge_efficiency_map_norm;					% Charging efficiency map [0-1]
		charge_efficiency_index_temp_degC;			% Charging efficiency map temperature axis [degC]
		charge_efficiency_index_soc_norm;			% Charging efficiency map SOC axis
		
		temperature_power_derate_index_temp_degC;	% Power Limit Temperature Derate Axis [degC]
		temperature_power_discharge_derate_norm;	% Power Limit Temperature Derate map when discharging [0-1]
		temperature_power_charge_derate_norm;		% Power Limit Temperature Derate map when charging [0-1]
		
		
		cell = class_REVS_battery_cell;				% Battery Cell properties (if available) as class class_REVS_battery_cell
				
		%pack = class_REVS_battery_pack;				% Battery Pack properties as class class_REVS_battery_pack calculated from cell properties if not provided
		
		thermal = class_REVS_battery_thermal;			% Battery thermal model as class class_REVS_battery_thermal;
		
	end
	
	properties ( Hidden = true, SetAccess = protected)
		private_series;
		private_parallel;
		private_cells;
		
		
		
	end
	
	
	
	properties (Dependent = true, Transient = true)
		
		num_series_cells;							% Number of cells connected in series in the pack
		num_parallel_cells;							% Number of cells or series collections of cells in paralel within the pack
		num_cells;									% Total number of cells in the pack
				
		capacity_nominal_Ah;						% Cell Nominal Capacity [Amp*Hours]
		
		open_circuit_voltage_map_V;					% Open Circuit Voltage Combined [V] - for future use
		transient_R_short_term_Ohms;				% Transient response short term RC resistance [Ohms] - for future use
		transient_R_long_term_Ohms;					% Transient response long term RC resistance [Ohms] - for future use
		transient_C_short_term_Fards;				% Transient response short term RC capacitance [Farads] - for future use
		transient_C_long_term_Fards;				% Transient response long term RC capacitance [Farads] - for future use
		resistance_map_Ohms;						% Internal Resistance Map [Ohms] - for future use
		
	end
	
	methods
		
		function obj = set.capacity_nominal_Ah(obj,val)
			obj.capacity_Coulombs = val * 3600;
		end
		
		function val = get.capacity_nominal_Ah(obj)
			val = obj.capacity_Coulombs / 3600;
		end
		
		function val = get.chemistry(obj)
			val = REVS_class_default( obj.chemistry, obj.cell.chemistry);
		end
		
		function val = get.capacity_Coulombs(obj)
			val = REVS_class_default(obj.capacity_Coulombs , obj.cell.capacity_Coulombs .* obj.num_parallel_cells);
		end
		
		function val = get.max_voltage_V(obj)
			val = REVS_class_default( obj.max_voltage_V, max(max(obj.cell.open_circuit_voltage_map_charge_V)) * obj.num_series_cells );
		end
		
		function  val = get.min_voltage_V(obj)
			val = REVS_class_default( obj.min_voltage_V,  min(min(obj.cell.open_circuit_voltage_map_discharge_V)) * obj.num_series_cells );
		end
		
	
		
		function obj = set.num_series_cells(obj, val)		
			
			if isempty( obj.private_cells ) || isempty( obj.private_parallel ) || ( val == obj.private_cells / obj.private_parallel )
				obj.private_series = val;
			else
				warning('Invalid battery definition num_series_cells * num_parallel_cells must equal num_cells');
			end
		end
		
		
		function val = get.num_series_cells( obj)

			if ~isempty(obj.private_series) 
				val = obj.private_series;
			elseif ~isempty( obj.private_cells) && ~isempty( obj.private_parallel)
				val = obj.private_cells ./ obj.private_parallel;
			else
				val = [];
			end
		
		end
		
		
		function obj = set.num_parallel_cells(obj, val)		
			
			if isempty( obj.private_cells ) || isempty( obj.private_series ) || ( val == obj.private_cells / obj.private_series )
				obj.private_parallel = val;
			else
				warning('Invalid battery definition num_series_cells * num_parallel_cells must equal num_cells');
			end
		end
		
		
		function val = get.num_parallel_cells( obj)
						
			if ~isempty(obj.private_parallel) 
				val = obj.private_parallel;
			elseif ~isempty( obj.num_cells) && ~isempty( obj.private_series)
				val = obj.num_cells ./ obj.private_series;
			else
				val = [];
			end
		
		end
		
		
		function obj = set.num_cells(obj, val)
			if isempty( obj.private_parallel ) || isempty( obj.private_series ) || ( val == obj.private_parallel * obj.private_series )
				obj.num_cells = val;
			else
				warning('Invalid battery definition num_series_cells * num_parallel_cells must equal num_cells');
			end
		end
		
		
		function val = get.num_cells( obj)
			
			
			if ~isempty(obj.private_cells) 
				val = obj.num_cells;
			elseif ~isempty( obj.private_parallel) && ~isempty( obj.private_series)
				val = obj.private_parallel .* obj.private_series;
			else
				val = [];
			end
		
		end
		
		
		function val = get.resistance_map_charge_Ohms(obj)
			val =  REVS_class_default(obj.resistance_map_charge_Ohms,  obj.cell.resistance_map_charge_Ohms .* obj.num_series_cells ./ obj.num_parallel_cells);
		end
		
		function val = get.resistance_map_discharge_Ohms(obj)
			val =  REVS_class_default(obj.resistance_map_discharge_Ohms,  obj.cell.resistance_map_discharge_Ohms .* obj.num_series_cells ./ obj.num_parallel_cells);
		end
		
		function val = get.resistance_map_index_temp_degC(obj)
			val =  REVS_class_default( obj.resistance_map_index_temp_degC, obj.cell.resistance_map_index_temp_degC);
		end
		
		function val = get.resistance_map_index_soc_norm(obj)
			val =  REVS_class_default( obj.resistance_map_index_soc_norm, obj.cell.resistance_map_index_soc_norm);
		end
		
		% Open Circuit Voltage
		
		function val = get.open_circuit_voltage_map_discharge_V(obj)
			val =  REVS_class_default( obj.open_circuit_voltage_map_discharge_V, obj.cell.open_circuit_voltage_map_discharge_V * obj.num_series_cells);
		end
		
		function val = get.open_circuit_voltage_map_charge_V(obj)
			val =  REVS_class_default( obj.open_circuit_voltage_map_charge_V, obj.cell.open_circuit_voltage_map_charge_V * obj.num_series_cells);
		end
		
		function val = get.open_circuit_voltage_map_average_V(obj)
			val =  REVS_class_default( obj.open_circuit_voltage_map_average_V, (obj.open_circuit_voltage_map_discharge_V +  obj.open_circuit_voltage_map_charge_V	) / 2 );
		end
		
		
		function val = get.open_circuit_voltage_map_index_temp_degC    (obj)
			val =  REVS_class_default( obj.open_circuit_voltage_map_index_temp_degC,  obj.cell.open_circuit_voltage_map_index_temp_degC);
		end
		
		function val = get.open_circuit_voltage_map_index_soc_norm    (obj)
			val =  REVS_class_default( obj.open_circuit_voltage_map_index_soc_norm,  obj.cell.open_circuit_voltage_map_index_soc_norm);
		end
		
		% Power Limits
		
		
		function val = get.powerlimit_charge_map_W(obj)
			val =  REVS_class_default( obj.powerlimit_charge_map_W, obj.cell.powerlimit_charge_map_W * obj.num_cells);
		end
		
		function val = get.powerlimit_discharge_map_W(obj)
			val =  REVS_class_default( obj.powerlimit_discharge_map_W, obj.cell.powerlimit_discharge_map_W * obj.num_cells);
		end
		
		function val = get.powerlimit_map_index_soc_norm(obj)
			val =  REVS_class_default( obj.powerlimit_map_index_soc_norm, obj.cell.powerlimit_map_index_soc_norm);
		end
		
		function val = get.powerlimit_map_index_temp_degC(obj)
			val =  REVS_class_default( obj.powerlimit_map_index_temp_degC, obj.cell.powerlimit_map_index_temp_degC);
		end
		
		
		function val = get.transient_RC_index_soc_norm(obj)
			val =  REVS_class_default( obj.transient_RC_index_soc_norm, obj.cell.transient_RC_index_soc_norm);
		end
		
		function val = get.transient_RC_index_temp_degC(obj)
			val =  REVS_class_default( obj.transient_RC_index_temp_degC, obj.cell.transient_RC_index_temp_degC);
		end
		
		
		function val = get.transient_R_discharge_short_term_Ohms(obj)
			val =  REVS_class_default( obj.transient_R_discharge_short_term_Ohms,   obj.cell.transient_R_discharge_short_term_Ohms * obj.num_series_cells);
		end
		
		function val = get.transient_R_discharge_long_term_Ohms(obj)
			val =  REVS_class_default( obj.transient_R_discharge_long_term_Ohms,  obj.cell.transient_R_discharge_long_term_Ohms * obj.num_series_cells);
		end
		
		function val = get.transient_R_charge_short_term_Ohms(obj)
			val =  REVS_class_default( obj.transient_R_charge_short_term_Ohms,  obj.cell.transient_R_charge_short_term_Ohms * obj.num_series_cells);
		end
		
		function val = get.transient_R_charge_long_term_Ohms(obj)
			val =  REVS_class_default( obj.transient_R_charge_long_term_Ohms,  obj.cell.transient_R_charge_long_term_Ohms * obj.num_series_cells);
		end
		
		
		function val = get.transient_C_discharge_short_term_Farads (obj)
			val =  REVS_class_default( obj.transient_C_discharge_short_term_Farads,  obj.cell.transient_C_discharge_short_term_Farads / obj.num_series_cells);
		end
		
		function val = get.transient_C_discharge_long_term_Farads  (obj)
			val =  REVS_class_default( obj.transient_C_discharge_long_term_Farads,  obj.cell.transient_C_discharge_long_term_Farads / obj.num_series_cells);
		end
		
		function val = get.transient_C_charge_short_term_Farads    (obj)
			val =  REVS_class_default( obj.transient_C_charge_short_term_Farads,  obj.cell.transient_C_charge_short_term_Farads / obj.num_series_cells);
		end
		
		function val = get.transient_C_charge_long_term_Farads     (obj)
			val =  REVS_class_default( obj.transient_C_charge_long_term_Farads,  obj.cell.transient_C_charge_long_term_Farads / obj.num_series_cells);
		end
		
		
		function val = get.temperature_power_discharge_derate_norm    (obj)
			val =  REVS_class_default( obj.temperature_power_discharge_derate_norm,  obj.cell.temperature_power_discharge_derate_norm);
		end
		
		function val = get.temperature_power_charge_derate_norm    (obj)
			val =  REVS_class_default( obj.temperature_power_charge_derate_norm,  obj.cell.temperature_power_charge_derate_norm);
		end

		function val = get.temperature_power_derate_index_temp_degC    (obj)
			val =  REVS_class_default( obj.temperature_power_derate_index_temp_degC,  obj.cell.temperature_power_derate_index_temp_degC);
		end
		
		% Charge Efficiency Map
		
		function val = get.charge_efficiency_map_norm    (obj)
			val =  REVS_class_default( obj.charge_efficiency_map_norm,  obj.cell.charge_efficiency_map_norm);
		end
		
		
		function val = get.charge_efficiency_index_temp_degC    (obj)
			val =  REVS_class_default( obj.charge_efficiency_index_temp_degC,  obj.cell.charge_efficiency_index_temp_degC);
		end
		
		function val = get.charge_efficiency_index_soc_norm    (obj)
			val =  REVS_class_default( obj.charge_efficiency_index_soc_norm,  obj.cell.charge_efficiency_index_soc_norm);
		end
				

		
		
		
		% 			val.resistance_map_charge_Ohms				= REVS_class_default(val.resistance_map_charge_Ohms,  cell_properties.resistance_map_charge_Ohms .* val.num_series ./ val.num_parallel);
		% 			val.resistance_map_discharge_Ohms			= REVS_class_default(val.resistance_map_discharge_Ohms,  cell_properties.resistance_map_discharge_Ohms .* val.num_series ./ val.num_parallel);
		% 			val.resistance_map_index_temp_degC			= REVS_class_default( val.resistance_map_index_temp_degC, cell_properties.resistance_map_index_temp_degC);
		% 			val.resistance_map_index_soc_norm			= REVS_class_default( val.resistance_map_index_soc_norm, cell_properties.resistance_map_index_soc_norm);
		%
		% 			val.open_circuit_voltage_map_discharge_V	= REVS_class_default( val.open_circuit_voltage_map_discharge_V, cell_properties.open_circuit_voltage_map_discharge_V * val.num_series);
		% 			val.open_circuit_voltage_map_charge_V		= REVS_class_default( val.open_circuit_voltage_map_charge_V, cell_properties.open_circuit_voltage_map_charge_V * val.num_series);
		% 			val.open_circuit_voltage_map_average_V		= REVS_class_default( val.open_circuit_voltage_map_average_V, (val.open_circuit_voltage_map_discharge_V +  val.open_circuit_voltage_map_charge_V	) / 2 );
		%
		% 			val.powerlimit_charge_map_W					= REVS_class_default( val.powerlimit_charge_map_W, cell_properties.powerlimit_charge_map_W * val.num_cells);
		% 			val.powerlimit_discharge_map_W				= REVS_class_default( val.powerlimit_discharge_map_W, cell_properties.powerlimit_discharge_map_W * val.num_cells);
		% 			val.powerlimit_map_index_soc_norm			= REVS_class_default( val.powerlimit_map_index_soc_norm, cell_properties.powerlimit_map_index_soc_norm);
		% 			val.powerlimit_map_index_temp_degC			= REVS_class_default( val.powerlimit_map_index_temp_degC, cell_properties.powerlimit_map_index_temp_degC);
		%
		% 			val.transient_RC_index_soc_norm				= REVS_class_default( val.transient_RC_index_soc_norm, cell_properties.transient_RC_index_soc_norm);
		% 			val.transient_RC_index_temp_degC			= REVS_class_default( val.transient_RC_index_temp_degC, cell_properties.transient_RC_index_temp_degC);
		%
		% 			val.transient_R_discharge_short_term_Ohms	= REVS_class_default( val.transient_R_discharge_short_term_Ohms,   cell_properties.transient_R_discharge_short_term_Ohms * val.num_series);
		% 			val.transient_R_discharge_long_term_Ohms	= REVS_class_default( val.transient_R_discharge_long_term_Ohms,  cell_properties.transient_R_discharge_long_term_Ohms * val.num_series);
		% 			val.transient_R_charge_short_term_Ohms		= REVS_class_default( val.transient_R_charge_short_term_Ohms,  cell_properties.transient_R_charge_short_term_Ohms * val.num_series);
		% 			val.transient_R_charge_long_term_Ohms		= REVS_class_default( val.transient_R_charge_long_term_Ohms,  cell_properties.transient_R_charge_long_term_Ohms * val.num_series);
		%
		% 			val.transient_C_discharge_short_term_Farads = REVS_class_default( val.transient_C_discharge_short_term_Farads,  cell_properties.transient_C_discharge_short_term_Farads / val.num_series);
		% 			val.transient_C_discharge_long_term_Farads  = REVS_class_default( val.transient_C_discharge_long_term_Farads,  cell_properties.transient_C_discharge_long_term_Farads / val.num_series);
		% 			val.transient_C_charge_short_term_Farads    = REVS_class_default( val.transient_C_charge_short_term_Farads,  cell_properties.transient_C_charge_short_term_Farads / val.num_series);
		% 			val.transient_C_charge_long_term_Farads     = REVS_class_default( val.transient_C_charge_long_term_Farads,  cell_properties.transient_C_charge_long_term_Farads / val.num_series);
		
		
		%
		%
		%
		% 		function val = get.pack(obj)
		%
		% 			% Copy Data currently in pack
		%
		%
		% 			cell_properties = obj.cell;
		%
		% 			val = obj.pack;
		%
		% 			if  (isempty( val.num_series) + isempty(val.num_parallel) + isempty( val.num_cells) ) < 1 && val.num_series * val.num_parallel ~= val.num_cells
		% 				error('Mismatch between number of pack series, parallel & cells');
		% 			elseif isempty( val.num_series) + isempty(val.num_parallel) + isempty( val.num_cells) > 1
		% 				calc_pack = false;
		% 			elseif isempty( val.num_series)
		% 				val.num_series = val.num_cells ./ val.num_parallel;
		% 				calc_pack = true;
		% 			elseif isempty( val.num_parallel)
		% 				val.num_parallel = val.num_cells ./ val.num_series;
		% 				calc_pack = true;
		% 			elseif isempty( val.num_cells)
		% 				val.num_cells = val.num_parallel .* val.num_series;
		% 				calc_pack = true;
		% 			else
		% 				calc_pack = true;
		% 		end
		%
		%
		%
		% 		if calc_pack
		%
		% 			%val.min_voltage_V  = min(min(cell_properties.open_circuit_voltage_map_discharge_V)) * obj.pack.num_series;      % ee-vert.pdf DISABLED FOR NOW
		% 			%val.max_voltage_V  = max(max(cell_properties.open_circuit_voltage_map_charge_V)) * obj.pack.num_series;      % ee-vert.pdf DISABLED FOR NOW
		%
		% 			val.capacity_Coulombs	= REVS_class_default( val.capacity_Coulombs, cell_properties.capacity_Coulombs * val.num_parallel);
		%
		% 			val.resistance_map_charge_Ohms				= REVS_class_default(val.resistance_map_charge_Ohms,  cell_properties.resistance_map_charge_Ohms .* val.num_series ./ val.num_parallel);
		% 			val.resistance_map_discharge_Ohms			= REVS_class_default(val.resistance_map_discharge_Ohms,  cell_properties.resistance_map_discharge_Ohms .* val.num_series ./ val.num_parallel);
		% 			val.resistance_map_index_temp_degC			= REVS_class_default( val.resistance_map_index_temp_degC, cell_properties.resistance_map_index_temp_degC);
		% 			val.resistance_map_index_soc_norm			= REVS_class_default( val.resistance_map_index_soc_norm, cell_properties.resistance_map_index_soc_norm);
		%
		% 			val.open_circuit_voltage_map_discharge_V	= REVS_class_default( val.open_circuit_voltage_map_discharge_V, cell_properties.open_circuit_voltage_map_discharge_V * val.num_series);
		% 			val.open_circuit_voltage_map_charge_V		= REVS_class_default( val.open_circuit_voltage_map_charge_V, cell_properties.open_circuit_voltage_map_charge_V * val.num_series);
		% 			val.open_circuit_voltage_map_average_V		= REVS_class_default( val.open_circuit_voltage_map_average_V, (val.open_circuit_voltage_map_discharge_V +  val.open_circuit_voltage_map_charge_V	) / 2 );
		%
		% 			val.powerlimit_charge_map_W					= REVS_class_default( val.powerlimit_charge_map_W, cell_properties.powerlimit_charge_map_W * val.num_cells);
		% 			val.powerlimit_discharge_map_W				= REVS_class_default( val.powerlimit_discharge_map_W, cell_properties.powerlimit_discharge_map_W * val.num_cells);
		% 			val.powerlimit_map_index_soc_norm			= REVS_class_default( val.powerlimit_map_index_soc_norm, cell_properties.powerlimit_map_index_soc_norm);
		% 			val.powerlimit_map_index_temp_degC			= REVS_class_default( val.powerlimit_map_index_temp_degC, cell_properties.powerlimit_map_index_temp_degC);
		%
		% 			val.transient_RC_index_soc_norm				= REVS_class_default( val.transient_RC_index_soc_norm, cell_properties.transient_RC_index_soc_norm);
		% 			val.transient_RC_index_temp_degC			= REVS_class_default( val.transient_RC_index_temp_degC, cell_properties.transient_RC_index_temp_degC);
		%
		% 			val.transient_R_discharge_short_term_Ohms	= REVS_class_default( val.transient_R_discharge_short_term_Ohms,   cell_properties.transient_R_discharge_short_term_Ohms * val.num_series);
		% 			val.transient_R_discharge_long_term_Ohms	= REVS_class_default( val.transient_R_discharge_long_term_Ohms,  cell_properties.transient_R_discharge_long_term_Ohms * val.num_series);
		% 			val.transient_R_charge_short_term_Ohms		= REVS_class_default( val.transient_R_charge_short_term_Ohms,  cell_properties.transient_R_charge_short_term_Ohms * val.num_series);
		% 			val.transient_R_charge_long_term_Ohms		= REVS_class_default( val.transient_R_charge_long_term_Ohms,  cell_properties.transient_R_charge_long_term_Ohms * val.num_series);
		%
		% 			val.transient_C_discharge_short_term_Farads = REVS_class_default( val.transient_C_discharge_short_term_Farads,  cell_properties.transient_C_discharge_short_term_Farads / val.num_series);
		% 			val.transient_C_discharge_long_term_Farads  = REVS_class_default( val.transient_C_discharge_long_term_Farads,  cell_properties.transient_C_discharge_long_term_Farads / val.num_series);
		% 			val.transient_C_charge_short_term_Farads    = REVS_class_default( val.transient_C_charge_short_term_Farads,  cell_properties.transient_C_charge_short_term_Farads / val.num_series);
		% 			val.transient_C_charge_long_term_Farads     = REVS_class_default( val.transient_C_charge_long_term_Farads,  cell_properties.transient_C_charge_long_term_Farads / val.num_series);
		%
		% 			end
		%
		% 		end
		%
		%
		% 		function val = get.thermal(obj)
		%
		%
		% 			val = obj.thermal;
		%
		% 			num_cells = obj.pack.num_cells;
		%
		%
		% 			val.pack_mass_kg = REVS_class_default( val.pack_mass_kg, val.cell_mass_kg * num_cells);
		% 			val.pack_heat_capacity_JpK = REVS_class_default( val.pack_heat_capacity_JpK, val.pack_mass_kg * val.pack_heat_capacity_JpK );
		%
		% 			val.pack_heat_transfer_area_m2 = REVS_class_default( val.pack_heat_transfer_area_m2, val.cell_heat_transfer_area_m2 * num_cells );
		% 			val.pack_total_conductance_WpK = REVS_class_default( val.pack_total_conductance_WpK, val.pack_heat_transfer_area_m2 * val.heat_transfer_coefficient_Wpm2K );
		%
		% 			% Removed Conduction Term - needs clarification
		% 		end
		%
		
	end
	
end

